package IO::K8s::Api::Admissionregistration::V1alpha1::ParamKind;
# ABSTRACT: ParamKind is a tuple of Group Kind and Version.
our $VERSION = '1.006';
use IO::K8s::Resource;

k8s apiVersion => Str;


k8s kind => Str;


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Api::Admissionregistration::V1alpha1::ParamKind - ParamKind is a tuple of Group Kind and Version.

=head1 VERSION

version 1.006

=head2 apiVersion

APIVersion is the API group version the resources belong to. In format of "group/version". Required.

=head2 kind

Kind is the API kind the resources belong to. Required.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartin@cpan.org> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Jose Luis Martinez.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
