#
# v5 should be all dupes.
#
use strict;
use warnings;
use Test::More;
use MyNote;
use MyTmpTimer;
BEGIN { use_ok 'UUID' }

my $n = 100;
my %seen = ();

my $fh = tmptimer( $n, sub {
    my ($n, $fh) = @_;
    my ($bin, $str);
    for (1 .. $n) {
        UUID::generate_v5($bin, dns => 'www.example.com');
        UUID::unparse($bin, $str);
        print $fh $str. "\n";
    }
});

while (my $str = <$fh>) {
    chomp $str;
    note $str;
    #ok !exists($seen{$str});
    $seen{$str} = 1;
}

is scalar(keys %seen), 1, 'all dupes';

done_testing;
