use v5.36;
use Test::More;

use Linux::Event;
use Linux::Event::Connect;

use Socket qw(
  AF_INET SOCK_STREAM SOL_SOCKET SO_REUSEADDR
  inet_pton pack_sockaddr_in
);

my $loop = Linux::Event->new;

my $ls;
socket($ls, AF_INET, SOCK_STREAM, 0) or die "socket: $!";
setsockopt($ls, SOL_SOCKET, SO_REUSEADDR, pack("i", 1));
bind($ls, pack_sockaddr_in(0, inet_pton(AF_INET, "127.0.0.1"))) or die "bind: $!";
listen($ls, 10) or die "listen: $!";
my ($port) = unpack("x2n", getsockname($ls));

my $accepted = 0;
my $connected = 0;

$loop->watch($ls,
  read => sub ($loop2, $fh, $watcher) {
    my $client;
    accept($client, $fh) or die "accept: $!";
    $accepted = 1;
    close $client;
    $loop2->unwatch($fh);
    close $fh;
    $loop2->stop if $connected;
  },
);

my $sa = pack_sockaddr_in($port, inet_pton(AF_INET, "127.0.0.1"));

my $req = Linux::Event::Connect->new(
  loop      => $loop,
  sockaddr  => $sa,
  family    => AF_INET,
  timeout_s => 1,
  on_connect => sub ($r, $fh, $data) {
    $connected = 1;
    close $fh;
    $loop->stop if $accepted;
  },
  on_error => sub ($r, $errno, $data) {
    fail("sockaddr connect failed: $errno");
    $loop->stop;
  },
);

$loop->run;

ok($connected, "sockaddr on_connect fired");
ok($accepted, "sockaddr server accepted");

done_testing;
