#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util::GMP qw/Pi/;
my $PI = '3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588174881520920962829254091715364367892590360011330530548820466521384146951941511609433057270365759591953092186117381932611793105118548074462379962749567351885752724891227938183011949129833673362440656643086021394946395224737190702179860943702770539217176293176752384674818467669405132000568127145263560827785771342757789609173637178721468440901224953430146549585371050792279689258923542019956112129021960864034418159813629774771309960518707211349999998372978049951059731732816096318595024459455346908302642522308253344685035261931188171010003137838752886587533208381420617177669147303598253490428755468731159562863882353787593751957781857780532171226806613001927876611195909216420199';


plan tests => 2;

is_deeply( [map { Pi($_) } 2 .. 999],
           [map { piround($_) } 2 .. 999],
           "Pi(2 .. 999)" );

# Call in void context
Pi(1200);

# Big enough to switch from AGM to Ramanujan binary splitting
like(Pi(3500), qr/3.1415926\d{3451}83579151369882091444210067510334671103141$/, "Pi(3500)");

sub piround {
  my $n = shift;
  return 3 if $n == 1;
  my $pi = substr($PI,0,$n+1);
  my $roundlen = ($n > 500) ? 8 : 3;
  substr($pi,-$roundlen,$roundlen)++ if substr($PI,$n+1,1) >= 5;
  $pi;
}
